﻿var exportResponsesWizard = {
    context: $(".v-exportResponsesWizard"),
    changeCategoryItems: null,
    init: function () {
        if (extractFormat == "OpenEndForCoding")
            $("#IsVariableSubset", this.context).prop("disabled", true);

    },
    bindEvents: function () {
        exportResponsesWizard.context.on("click", ".h-testConnection", function () {
            var panel = $(this).closest(".v-serverCredentials");
            var editor = $(this).closest(".v-exportResponsesWizard");

            a4.callServerMethod(a4.getSurveyAction("TestFTPConnection", "Analyze"), { id: $("#Id", editor).val(), isImport: false, address: $("#FTPAddress", panel).val(), username: $("#FTPUsername", panel).val(), password: $("#FTPPassword", panel).val(), folder: $("#FTPFolder", panel).val(), security: $("#FTPSecurity:checked", panel).val(), openSSHPrivateKey: $("#OpenSSHPrivateKey", panel).val() },
            function (result) {
                if (result.Success)
                    a4.showSuccessMessage(result.Message, 2000);
                else
                    a4.showErrorMessage(result.Message);
            }, function (error) {
                a4.onAjaxPageMethodError(error);
            });
        });

        $('input[type=radio][name=FTPSecurity]').on("change", function () {
            if ($('input[type=radio][name=FTPSecurity][value=SFTP]').is(':checked'))
                $("#sftpPrivateKey").show();
            else
                $("#sftpPrivateKey").hide();
        });

        
        exportResponsesWizard.context.on("change", "input[type='radio'][name='ResponsesSubsetType']", function () {
            var parent = $(this).closest(".field");
            var subset = $(".h-responseSubset", parent).is(":checked");
            $(".h-editFilter", parent).toggle(subset);
            parent.siblings(".v-filterSummary").toggle(subset);

        });

        exportResponsesWizard.context.on("change", "input[type='radio'][name='IsVariableSubset']", function () {
            var parent = $(this).closest(".field");
            var subset = $(".h-variableSubset", parent).is(":checked")
            $("#MaxRecordWidth", exportResponsesWizard.context).prop("disabled", !subset);
            $(".h-selectVariables", parent).toggle(subset);

            $("#variableSelectorContainer").toggle(subset);

            if (subset) {
                exportResponsesWizard.loadVariableList();
            }
        });

        exportResponsesWizard.context.on("change", "#DichotomizedMultiple", function () {
            var dichotomize = $(this).is(":checked");
            var isTripleS = $(".h-tripleSFormat:checked", exportResponsesWizard.context).length > 0;

            $(".v-dichotomizedIgnoreChoiceHeader", exportResponsesWizard.context).toggleClass("hidden", !dichotomize);
            $(".v-dichotomizedWhenEmptySection", exportResponsesWizard.context).toggleClass("hidden", !dichotomize);
            $(".v-allNumericCodesSection", exportResponsesWizard.context).toggleClass("hidden", !(dichotomize && isTripleS));

            $("#DichotomizedEmptyWhenNoAnswer, #AllNumericCodes", exportResponsesWizard.context).prop("checked", false);

            $(".h-hideDichotomize", exportResponsesWizard.context).toggleClass("hidden", $(this).is(":checked"));
        });

        exportResponsesWizard.context.on("change", "#EncryptWithPGP", function () {
            var checked = $(this).is(":checked");

            $(".v-pgpPassphraseSection", exportResponsesWizard.context).toggleClass("hidden", !checked);

            $(":radio[name='CompressFiles']", exportResponsesWizard.context).prop("disabled", checked).prop("checked", false);
            $(":radio[name='CompressFiles'][value=True]", exportResponsesWizard.context).prop("checked", true);
        });

        exportResponsesWizard.context.on("change", "#IncludeRespondentFiles", function () {
            var checked = $(this).is(":checked");

            $(".files-structure-selection", exportResponsesWizard.context).toggleClass("hidden", !checked);
        });

        exportResponsesWizard.context.on("change", ".h-hideDichotomize :checkbox", function () {
            var showDichotomize = $(".h-hideDichotomize :checkbox:checked", exportResponsesWizard.context).length == 0;

            $("#DichotomizedMultiple", exportResponsesWizard.context).prop("checked", false);
            $("#DichotomizedEmptyWhenNoAnswer", exportResponsesWizard.context).prop("checked", false);
            $("#DichotomizedIgnoreChoiceHeader", exportResponsesWizard.context).prop("checked", false);

            $(".v-dichotomizedMultipleSection", exportResponsesWizard.context).toggleClass("hidden", !showDichotomize);

            if (!showDichotomize) {
                $(".v-dichotomizedWhenEmptySection", exportResponsesWizard.context).addClass("hidden");
                $(".v-dichotomizedIgnoreChoiceHeader", exportResponsesWizard.context).addClass("hidden");
            }
        });

        exportResponsesWizard.context.on("change", "#DapresyDataFormat", function () {
            $("#DichotomizedEmptyWhenNoAnswer", exportResponsesWizard.context).prop('disabled', this.checked);
        });

        exportResponsesWizard.context.on("change", "#IncludeOpenEnds", function () {
            $(".v-openEndsInRespondentRecordSection", exportResponsesWizard.context).toggleClass("hidden", !$(this).is(":checked"));
            $("#OpenEndsInRespondentRecord", exportResponsesWizard.context).prop("checked", false);
        });

        exportResponsesWizard.context.on("change", ".h-tripleSFormat", function () {
            var dichotomize = $("#DichotomizedMultiple", exportResponsesWizard.context).is(":checked");
            var isTripleS = $(".h-tripleSFormat:checked", exportResponsesWizard.context).length > 0;

            $(".v-allNumericCodesSection", exportResponsesWizard.context).toggleClass("hidden", !(dichotomize && isTripleS));

            if (!(dichotomize && isTripleS)) {
                $("#AllNumericCodes", exportResponsesWizard.context).prop("checked", false);
            }
        });

        exportResponsesWizard.context.on("click", ".h-selectVariables", function () {
            variableEditor.showVariableSelector();
        });

        exportResponsesWizard.context.on("keypress", "#Name", function (event) {
            a4.validateNameKeyCode(event);
        });

        exportResponsesWizard.context.on("change", ".h-recalculateRequired", function () {
            if (extractFormat == "TXT" && $.trim($("#JSONVariables", exportResponsesWizard.context).val()).length > 0) {
                a4.showSuccessMessage(resources.CalculateAllPositionsRequired);
                $(".h-recalculateRequired", exportResponsesWizard.context).removeClass("h-recalculateRequired");
            }
        });

        exportResponsesWizard.context.on("click", ".h-editFilter", function () {
            var url = a4.getSurveyAction("RespondentFilter", "Shared");
            
            $("#RespondentFilterDefinition").val($("#RespondentFilter", exportResponsesWizard.context).val());
                       

            modalDialog.showWindow(url, 785, 1050);
        });
        exportResponsesWizard.context.on("keydown", "#RecipientList", function () {
            var parent = $(this).closest("div");
            $(".v-emails-count", parent).text(a4.countEmails($(this).val()));
        });

        exportResponsesWizard.context.on("change", "#RecipientList", function () {
            var parent = $(this).closest("div");
            $(".v-emails-count", parent).text(a4.countEmails($(this).val()));
        });

        exportResponsesWizard.context.on("change", ".send-by-email", function () {
            $("#RecipientList").prop("disabled", !$(this).prop("checked"));
        });
    },
    loadVariableList: function () {
        var cnt = $("#variableSelectorContainer");

        if (!cnt.hasClass("loaded")) {
            a4.callServerMethod(a4.getSurveyAction("InlineVariableEditor", "Analyze"), {},
                function (result) {
                    $("#variableSelectorContainer").html(result);
                    variableEditor.initVariableEditor();
                    cnt.addClass("loaded");
                });
        }
    }
}

$(document).ready(function () {
    if (exportResponsesWizard.context.length > 0) {
        exportResponsesWizard.init();
        exportResponsesWizard.bindEvents();

        a4.initializeInputs(exportResponsesWizard.context);

        if ($("input[type='radio'].h-variableSubset").is(":checked")) {
            $("#variableSelectorContainer", exportResponsesWizard.context).show();
            exportResponsesWizard.loadVariableList();
        }

        $('input[type=radio][name=FTPSecurity]').trigger("change");

        $("#RecipientList").prop("disabled", !$(".send-by-email").is(":checked"));
    }
});

function SetRespondentFilter(filter) {
    $("#RespondentFilter", exportResponsesWizard.context).val(JSON.stringify(filter.Definition));
    $("#RespondentFilterSummary", exportResponsesWizard.context).html(filter.Summary);
    $(".v-filterSummary", exportResponsesWizard.context).toggle(filter.Summary != "");
}

function SetResponsesSelection(data) {
    $("#JSONVariables", exportResponsesWizard.context).val(data);
}